(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    142490,       2399]
NotebookOptionsPosition[    141901,       2381]
NotebookOutlinePosition[    142313,       2397]
CellTagsIndexPosition[    142270,       2394]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.9733405774128227`*^9, 
  3.9733405774128227`*^9}},ExpressionUUID->"69f4cbaa-ac24-4f2b-90e7-\
b21de5767049"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"anchoventana", "=", "2"}], ";"}], "\n", 
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", "*", 
      RowBox[{"x", "^", "2"}]}], "-", 
     RowBox[{"8", "*", "x"}], "+", 
     RowBox[{"4", "*", 
      RowBox[{"y", "^", "2"}]}], "-", 
     RowBox[{"8", "*", "y"}], "+", 
     RowBox[{"4", "*", 
      RowBox[{"z", "^", "2"}]}], "-", 
     RowBox[{"8", "*", "z"}], "+", "12"}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "anchoventana"}], ",", "anchoventana"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "anchoventana"}], ",", "anchoventana"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "anchoventana"}], ",", "anchoventana"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesOrigin", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}]}], ",", 
   RowBox[{"Boxed", "->", "False"}]}], "]"}], "\n"}], "Input",
 CellChangeTimes->{{3.9733405692796817`*^9, 3.9733405692806816`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"af2e5bbe-c95d-4e09-b860-4a3422938bf3"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyEvXk81F/0Py5LqZREURKptEeLaL0tElqkjQot0kZIUrShlDZLIoQiIqkk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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtmnfgjlUbx5/7fu7xkEq2kC0ZmaEoo6JkZGVHiOwREUK27EoKkTcvEWXv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            "]], Polygon3DBox[CompressedData["
1:eJxFnAf8j9UXx5/vM78tUipEiJQRLVIoiqxIyiplNrSsUBq0095bRkZDU4OG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            "]], Polygon3DBox[CompressedData["
1:eJwtmXXcFsUahrfe/V6Dkm5QJAXho0Q8qKSUqIA0SMihQxoJA0TpBgPwWHQj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            "]], Polygon3DBox[CompressedData["
1:eJwt1XuQT2Ucx/Gzu7/97Ypqamqo0bBrVdOU1URu5ZrFH24rImFR0ZAlpSYm
1sqdiiQlO9QoZRqX3IuKxmV0QaFRGGVFbpMwbun1zDl/fOZ5P5/v5TznPM85
J29AafGwzCiKelKajuZE0Q+MLiZ/4u24M55Kj2dF0Y5kfkjsMA3MjqI3M6Lo
iDGT5uA/jPtTUVSMV8odL2+Iuob4GA3jd5XTPMTCtXKjqMi8E38Fr0z+M/zd
epRQPzotvtz6llEunkwtrGeP3Cn4H/6dxhVya+hTgQupNf8F3jx9J8lvq+8D
4hPwdbXfUR1cLncLzsfD5HY3f1nePFqq5jNK87rRSN5x4zL59+h9Ap/FI9Xe
JlYotxTP0WcJLcBHePXE5uPq7netutrmi9VeVPug+DJeS/mT8XkaFK4jv438
dfyv8RS5a/EmPBWXqeniHs8bd+n1ipoexiI1F/TohHfQEP7fcuqqbcXPzI2f
yWR9svAuvZrhSr02izfGr4mfUnsy3B9tEFtPN+BpdAHXNM7Xt7qa/WHfzN9x
rUtqPw/PVqySN9P8ST13yssW74OPixfy+/Kes4azYT1ifcP+4uKwX3LmmUf8
vLCf8v7iHwz3kdxjbzwt7Bm/g/xbcS1+O/x08mzv4i23ltv1WaBPjnk1/la6
Ftrz6/Dv5bfjdaAGvDfCeciJz+Qq3JV3WuxZekjuz3SY38xaduPfcVPcHn8s
Z4m6PvpOUnfAWGGeZR0/4pLwwslfyKuCbwnvVk78rHrxO+ET+Dqejx/F4+S8
jxfTQvyvXr30GqP/3uz4Gd7My1UznjeF+vHv5z8h/9VQi+eKj86J/Z789bTH
clrLr8crp5ZytoSzyG+VvGsX9f6QN8A9DpDTQGxgeEfNc42neCW4Qk4RrpqO
z8ZBtXOz4z09gHfTI3hcOj57TfBYvFJOS2vYGZ5RKj4bY8RP41L+lbAH+lea
H6Pu1NAaVhvPydsvv1ifPDmDwx7ifan427JG70upeC9+xYPlNA73zmtv3oO/
wdhITSn/PvERufE7fo33Il7Cv24+1LXGWsvS8G6FveHXScc9bxI/gwfhRvza
uA29hd+T+312/A08lYq/jav16WZ+RnwoPSz3birChXpszI7f/fphLbQ+yX9e
fAQ1kTtaznbPYZSeF/A+8YLw3MI5T85DGa+ceosvyonPXX/xDLGUnJ/4H/HS
eJS8d/WukuzpYzTLfDYNF/svK76XPeFfkJz5Xfg33ATPENuCN/Jm4m/xhuSb
kK/nLD1u5BXgy/y9xl8oX+0KfkfxttbTONmLAv4XeK1YXdwCT+RPSL6TR/mz
9R6qxzbzrXROfVWqFr6xyTPJk3Me78X5eA5Vqt3OexsfS74tM8ynUy264rl2
5rcOZzb5R5Txm+HLGfGPM6xtTfiPhO8EXocn4Om0GX+Vjp/JN3iT2on4JWtv
Gv5LeCP/S/5x6389M76XbeGM6t/R+Km8iuTf8Qn+ANfAi8TukLNKXddw1sO3
SW1zKpBzyPKuiF+jzHR8P5d5s4wL1VzFs3F52Gc5J+lqOJ/hfaP++gxP/mUl
OEP/FO6D6+Oa+KnwHcHV8f9vfRZY
            "]], 
           Polygon3DBox[{{1424, 249, 1182, 1309, 247, 848, 2009}, {1676, 854, 
            542, 1194, 1552, 541, 1867}, {1713, 948, 615, 1235, 1712, 947, 
            1920}, {1945, 1021, 1484, 1630, 764, 1020, 1483}}]},
          Annotation[#, "Charting`Private`Tag$15911#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {{}, {}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwt0E1KglEYhuFTqaWhDkrBkTYyHQuKuoegeSnipIgcRv7uwrKJ+wh3Imi5
kbwONLi5n+9533M4fDeD0f3rSQjhDo1ECKfc5x42Bl3f33LLoJIKocllftHX
5Wu5xreo4ln/hDd5ynOexYy9e2a6idx1bswdfued2dxsIf/IvzhgrNvyhB+w
lD/wiT/vO3P+UZ92LilnOMWX3NOv7CVjh3NcoK+/im9HARn7RR7ov+xn454u
x0PdWleS87FDNlrf1if+/9sRPDQcdA==
        "]], Line3DBox[CompressedData["
1:eJwt0L9KgmEUgPEjZUvgJQQ62FQ6lotO/VuM1py+ci1IISjIIYymEBK8hegK
uoJcq6mgGoQgCALLRWroJzQ8POc878fLy5dN9rf2UhGxiY3piPxk5gLXeBs3
PijZr9MRx1MROfuVeY4P7b2ZiFlz3byLHXS0hDP6iL8x0L54iER/5Qfthe/5
me+47uzW/X0MtEftCe/ecKbltQN7A0286UvaiXmZW1ziT32BF3GkFbiID32F
29oqr2F98i793P1l86mzCo+0jjbmC65qP+ZL8y93ef7/3/0BJlAtHQ==
        "]], 
       Line3DBox[{1107, 52, 1123, 1124, 61, 1609, 1610, 681, 1279, 1280, 131, 
        683, 1286, 130, 672, 671, 1606, 670, 669, 113, 580, 579, 578, 1573, 
        577, 112, 584, 1576, 583, 116, 1575, 1574, 582, 1219, 1218, 115, 1238,
         1237, 1236, 616, 1588, 120, 1245, 629, 1594, 630, 121, 625, 1593, 
        626, 627, 628, 117, 601, 602, 1581, 603, 604, 118, 1231, 606, 1583, 
        55, 438, 50, 1106, 1107}], 
       Line3DBox[{1109, 53, 1114, 1113, 57, 441, 59, 1200, 561, 1565, 109, 
        550, 549, 1555, 548, 547, 107, 651, 650, 649, 1600, 648, 127, 641, 
        1597, 640, 1251, 128, 1598, 642, 1253, 1254, 1255, 89, 1169, 1170, 
        506, 1536, 1537, 90, 509, 1538, 510, 91, 513, 1540, 514, 515, 516, 97,
         527, 528, 1545, 529, 530, 99, 1543, 524, 101, 1548, 1547, 535, 1180, 
        1179, 54, 1110, 1109}], 
       Line3DBox[{68, 69, 1760, 1003, 1004, 363, 1482, 361, 999, 1758, 1000, 
        294, 894, 295, 898, 297, 899, 1453, 85, 490, 84, 1440, 279, 1439, 280,
         1444, 1445, 255, 1432, 1433, 256, 853, 1675, 260, 854, 1676, 261, 
        861, 860, 265, 885, 884, 883, 276, 1437, 877, 273, 1435, 224, 803, 
        1411, 1410, 226, 1769, 1021, 1484, 364, 1017, 365, 1766, 1765, 1018, 
        68}], Line3DBox[CompressedData["
1:eJwt0C1LQwEUxvEzfEsaFp2GBc3TfQdhdXEwEIO2LfkR1DYQHCzuzrjpzCqo
iC8wF6YLisGgYjSZLP4uGB7+5/kfzr2Xm9+ol2uZiCjL5lREglvYwW08xbPU
TUdkJyLOza/8nqMXnJuM+Lbb1WfNO7iIC/LD53Be1vmx+yd5lBu7EVb4e7zS
7/ASb/ECq3bX3vGsD/QHGUqR7/Mn0rBLuI4U+ETvph17eIhrfA/7+hEep7OU
+IJvW5HMTMQqFqXFf3n2kvnXzTIecG9c3tww78u73sRP/JD2/z/8AwMtMQ8=

        "]], Line3DBox[CompressedData["
1:eJwt0DFLgmEUhuEjUoPQ0A9ocGhIW6upBss1qB+QGRG1lI2KDoVuheDUXhFt
2W+oNacKaxICQbAEl2jqGhxu7vM8h/f9Pt703sn2cSIitnA4FXHDR3zLJX7g
Ng6mI2aTEY/me33aoYp8pS/znW5Ol0JR3kXTrsA7mNGP+Aff6NkNuaj/5I78
wS/c5Sf37ds9c09+1b/hHX3/UNc3MG9X0p3iS78kV83LXOMVHuoXuCxnOItF
DPQ5XkfdboPzGOnP5FXzOa/xWNf0vV/elC/NF/iTW3w9eb9/T+YuwA==
        "]], Line3DBox[CompressedData["
1:eJwl0D1LQmEchvG/mI4VWWuYUy8Q9B2E5pqCoEGaGnKoLxAtUULQ0FC6lbm0
hQoNpYG9rjU59BEKwXKpftBwcV/3c5/ncDhTheLyZiIilrCRiqjJz3TE6FDE
vmEPH/qIvsN3McF7zsZlBmPourtme0lG3Nme5RMe0dZXbG1+zVvyxvOrzt54
x9k9HvCq39oWbAf8xNkpyijpFTlvK/Mar8i8fuXOGT9HFZe2C7lo++HTvnEG
s/jV5+SxbcBz/Ih/8ywv8S/ex6R+qL97f9O/2ZJ12cA2r8p1zw0n///fH6T2
MMc=
        "]], Line3DBox[CompressedData["
1:eJwl0L8rxGEcwPGPOJYrWfyYpDPeufI/KPNtV0pZXa7zJ8hy6erKYMPGl7Jg
uELhDBRuU8oVg9Egk8nryfDu/Xne3+/zfH/MrNQrawMRUUEtF3HA51g3n3KD
z7iDd/MH2jZMD0W8mVvmPm/zrPY7HFHgT21HK5vnUEKMRBR5UT8ejDjCifsz
PsSCvp+6tscZ73I59dTSGq20z/nz+oP1PV60G+0aS/qFdqtdcpev+I6rrj3y
E7raM/ewrI97tx9tgicxhU39S8ubN8xNbOFbG9NePS/zaaPOWM39/8M/UEEw
kw==
        "]], Line3DBox[CompressedData["
1:eJwl0L1KAlAchvF/hE1B3YFFg65lWy2uZWBegpHlkE6ZYENTUk0G3oJDH3ox
NVVSoAhBIARpYz9peHif97wcOJzVYrVQmYuIAu5wjwdUEhFdebgQsTwfUdV7
s12e62suraCjJ2Xd2aIsy1t3juURSmjpS7ZfPuRTOcEPBvqB7YM/83f5JEvO
hvyVv6GPgf4iP70jxU95DWdI63U5sm3xC74tx3rTG9f5BjJo2Dbll+3atsN3
kcOlbU9+265s2dk7eYvn+ZTf8Ilsy31nTXce9ZPE/x/+AXgTMFc=
        "]], 
       Line3DBox[{1398, 190, 1399, 191, 272, 1436, 874, 1683, 875, 1684, 274, 
        878, 275, 876, 259, 851, 1674, 852, 258, 262, 263, 1434, 855, 1677, 
        199, 1401, 197, 1400, 198, 200, 1644, 798, 1406, 218, 796, 219, 797, 
        217, 195, 787, 196, 788, 193, 194, 790, 1641, 789, 1640, 192, 189, 
        1398}], Line3DBox[{1402, 202, 204, 1642, 791, 1643, 792, 205, 208, 
        794, 209, 793, 210, 221, 801, 222, 800, 220, 1407, 799, 1645, 216, 
        213, 1404, 214, 1405, 215, 370, 1025, 1771, 1024, 372, 1487, 1027, 
        1772, 369, 313, 912, 314, 915, 1700, 914, 1699, 913, 309, 1457, 312, 
        203, 1403, 201, 1402}], 
       Line3DBox[{206, 207, 343, 1466, 956, 957, 342, 1467, 341, 951, 1716, 
        952, 316, 917, 315, 922, 321, 923, 1703, 322, 211, 795, 212, 378, 
        1490, 377, 1489, 376, 1492, 1493, 383, 1512, 1513, 371, 1026, 1486, 
        373, 1028, 1488, 374, 1030, 1029, 298, 902, 901, 900, 301, 1701, 916, 
        310, 1458, 311, 959, 1720, 1719, 335, 1465, 947, 1712, 331, 944, 330, 
        1462, 1461, 945, 332, 206}], 
       Line3DBox[{1408, 225, 1483, 1020, 367, 1019, 1768, 1767, 366, 1485, 
        1022, 368, 1770, 1023, 360, 1480, 997, 359, 1001, 1759, 1002, 362, 
        1481, 998, 293, 893, 292, 896, 897, 296, 1452, 895, 277, 1438, 278, 
        886, 1686, 284, 283, 282, 1441, 281, 1442, 1443, 254, 1430, 1431, 850,
         1672, 1673, 253, 257, 859, 858, 1678, 857, 856, 264, 882, 881, 880, 
        1685, 879, 227, 804, 223, 1647, 1646, 802, 1409, 1408}], 
       Line3DBox[{903, 300, 911, 308, 1722, 1721, 960, 1470, 1469, 336, 1713, 
        948, 333, 946, 1464, 1463, 334, 1714, 949, 337, 1468, 958, 338, 1715, 
        950, 339, 954, 1718, 955, 340, 1717, 953, 317, 918, 318, 920, 921, 
        319, 1702, 919, 320, 1459, 323, 1035, 1496, 381, 382, 379, 1491, 380, 
        1494, 1495, 384, 1788, 1789, 1063, 1514, 1515, 409, 375, 1034, 1033, 
        1773, 1032, 1031, 299, 906, 905, 904, 1689, 903}]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwl0DFLgmEUxfGrb6RLEFg0WFDRkENFU4FTBDUIQWFDQQg5CBK2BW3RdwjC
VMgc+w7tDn4Dx4KWoiWICPqJw+F/zrn3ed6Hd+n88qiRiohjSmciHoQMPuEH
bfDrNJ9EfMpf9CffysN0RJ0v4o38y6/wNb5Kh3IFV3X5iYiLbMQc5uhUl5Pv
zd/5a7tlbMqz+h/feZEX5S2zbfrWtSnhWziFz9iyd0cdOdxddj6ce5S7lPCT
+h6fxYp5x36BX6MreRNndLt2d+ztY4mmdQfyyeideIbLuhK/gHujd+v6/Cs/
wDdspsb/8x+gsyXo
        "]], Line3DBox[CompressedData["
1:eJwl0C1Lg2EYxfFrb25NfMEgMzwYXFiYRRBMBoNgUTYUhmFBsLhqcZ9CDcp0
viSbH8MPYBu4YBhMwaCoIOjvwXD4n3Ou6+a5nztptTcPMhHRoHwx4lIoYA+X
8RM/aIl/xyQX8YXTpYhhNuJEPjQ7xQldXbdDk/mIO/0MztKCbtdOi0b6PZzX
9elbPpL3sYMruh/+zXfm5EX+hX+lGn+LJbzGMbzCZ3xw7gkHtOVcWV7nE2zK
Q34bN3A8nfGP/Bqu0pSu5q5VutdXsJve238V+RtdAbN2e+lbUU5umv/a68rH
eE5ndJH5f9M/nnMp6g==
        "]], Line3DBox[CompressedData["
1:eJwl0LFKgnEUhvFjBtaSBC1JDkFDJFHUFYQQDk0KgkMFXsAnZXNLNNRat5BD
kNLU0AUYCEXUntQgtEQI2tgvGl6e57yH//ngW6w3ykkqIqoynYloGWbwBhfw
AbuS53PpiB7fnooYTURs4UB3afdj/uTnOMaS3RC/5Fj3gk+yoe9hU3ePCZ54
f8eX7BrmFfzwnZzuDZft+/guBd7BLLZxFm+x4t2OHJqbciQD84UbWff6/JQH
P8NJLOpafJ5fY1syugKuyaMbm5jW1fkB//67ja+6Gk/4M1+VXfM67uOeXKX+
/+kvzSAsxg==
        "]], Line3DBox[CompressedData["
1:eJwl0L9KgmEYhvHnKyMxh6CpmhoKioiGDiCiSbBB0PZawyIym1qKglpcPIYy
hxrzEAqHCDsAIcIpRIIc+0nDxf3c1/vne/kW9g4L5SQiishMRtwrL5g3z2Fm
POJVb+N3LGIrHdHj6ta+5KZ+zd8iZx5yP+jjgqviDB39DW3UnD3h+lhypsVd
cs9yUT/iP32vJWe5ZWsr6HJPmDY3ZVY+yLx9FfMpqqg5k3HPDt/FlZ7oN3JC
bnPn9t3pTTwiza3KdWyM3mo9xe3LY30gK/KDe8e3fqDvyhKKWOMb3jM1ujv5
/59/VR4s8A==
        "]], 
       Line3DBox[{1810, 783, 434, 448, 786, 447, 444, 445, 785, 443, 440, 
        1972, 784, 1813, 686, 435, 1811, 436, 1812, 437, 2010, 849, 1859, 538,
         710, 709, 847, 1858, 846, 537, 680, 1057, 780, 2160, 1055, 1964, 
        1054, 2159, 682, 688, 1974, 687, 1973, 446, 685, 1971, 782, 1810}], 
       Line3DBox[{438, 439, 778, 2154, 1040, 1041, 679, 1961, 777, 1038, 2152,
         568, 890, 731, 891, 569, 892, 2040, 570, 442, 441, 729, 2036, 565, 
        2035, 728, 2037, 2038, 539, 2013, 2014, 535, 2008, 536, 848, 2009, 
        708, 832, 830, 526, 1062, 1060, 781, 1965, 1056, 779, 2158, 681, 2164,
         2163, 677, 2149, 2148, 675, 2146, 774, 2147, 676, 438}], 
       Line3DBox[CompressedData["
1:eJwl0LErhHEcx/Hv3aVTDLcIWe6Kckm68gdQDCy6U4abrhvpPNlZlM5wJVH+
AYPBwkDqFoPBIOmSJKNJ0g23e12Gd5/P+/P7PXdPT6GeVLZTEbGBq3TEPRnP
RjzIOzmSicjLDl8ajPjmLfcOcGL/4j39ECvOe7yLH5w537XP21/4Ex5xZN+x
N3DD9/mW3kWbT7v/6f/a9lE+JW+dvdteUeBvclJ+yDVnZawi6b+TPPbckN8Z
xqmek8v2pp7WF/U9d8/5BS4xYR+wL9iLfBYlPPOUvSYTPqf/6o3+mb6uV7DJ
Z3hVv5Zj2f9v+gdNAy2I
        "]], Line3DBox[CompressedData["
1:eJwl0EErwwEcxvHftsLFjpvcWFm0HHgHJAcXLWXFxa4WG2c3EwcXB+/AwcHJ
RZMLclCTRpI0N6WEdnDlI4dv3+d5fvv/tzZQXi2uJCJiHpnuiAsly5d8hVO5
gUwq4l6f6ol4l/dtu8mILWzizTbptiN/yx1M6x+8YWvxuH7D11iz5fWG/ClX
0EHde89sw25t39cnD9nyOHF/suXkBx7kR37GrFsRM6jaa3iV9zzf611pvPz9
Vv3HbZtTtgnbgXyIfv2Iu2wj3PS5UR5D0rakV+UvXuc7W0m+5TlethXkRXkB
x/J54v9//QUsTC+e
        "]], Line3DBox[CompressedData["
1:eJwl0M0rRFEYx/HnMmUsFZOFZrKwICxm1lMWisXUlGbuLZqaZKGElZSd/A8i
C/+FFalZe0mp2dmo0Sgb9vK5WXz7vZzznHM6s9uHGwdJRLTwyDyhPBbxQj9o
NhrRoJWRiDVapqnunX/gN/kmP8H3aUNexype5Sn9cTGiWohYxgKO5Gt9l47L
F3yHL/CJuYxP0UaiO7d+hyXn3dJFOvC+IXr528zU6I9cMnMld+zLcKJP6aVu
i+5Zn3TmNGawL8/rP+3r2rODXXzJc/pT/i2fk+t0BWe6X/nbfff5n8hVemOt
Qp+T/7/8AxcNJ+U=
        "]], 
       Line3DBox[{485, 795, 698, 600, 1915, 919, 2066, 746, 604, 1045, 1963, 
        1049, 1053, 554, 865, 869, 2028, 873, 550, 575, 2042, 895, 1900, 574, 
        491, 490, 1984, 1985, 466, 464, 1975, 1976, 692, 693, 544, 1864, 1865,
         853, 2017, 2018, 715, 717, 859, 1872, 530, 845, 2006, 841, 837, 534, 
        1075, 1071, 1970, 1067, 672, 2145, 1034, 665, 663, 2139, 2138, 1026, 
        2137, 2136, 766, 488, 487, 1982, 1981, 699, 702, 1845, 1844, 485}], 
       Line3DBox[{1851, 506, 1996, 808, 1995, 707, 824, 821, 521, 929, 926, 
        738, 2055, 908, 1901, 582, 2095, 2094, 749, 2083, 948, 615, 946, 2082,
         2081, 616, 2102, 982, 755, 1932, 963, 966, 633, 985, 988, 2105, 756, 
        996, 2111, 642, 2128, 2129, 1019, 764, 1020, 2130, 705, 1850, 1851}], 
       Line3DBox[{1852, 802, 1988, 1987, 706, 1945, 1021, 761, 2123, 1017, 
        763, 1944, 655, 657, 1946, 1022, 765, 1947, 640, 991, 2106, 989, 986, 
        634, 967, 964, 1933, 961, 629, 1926, 618, 949, 1921, 613, 611, 1919, 
        608, 944, 2076, 609, 947, 1920, 748, 1928, 1929, 960, 2096, 2097, 585,
         583, 924, 2071, 927, 930, 522, 822, 825, 2001, 827, 509, 507, 1853, 
        1852}], Line3DBox[{1854, 804, 704, 1990, 1989, 803, 1992, 1991, 508, 
        762, 2125, 2124, 654, 2127, 2126, 1018, 656, 658, 659, 2131, 1023, 
        1948, 641, 992, 2107, 990, 987, 635, 968, 965, 1934, 962, 630, 1927, 
        958, 2091, 750, 614, 612, 945, 2079, 2080, 747, 2077, 2078, 610, 617, 
        2092, 2093, 959, 1930, 1931, 740, 911, 1902, 584, 925, 2072, 928, 931,
         523, 823, 826, 2002, 828, 510, 1854}], 
       Line3DBox[{1855, 805, 1993, 806, 1994, 807, 512, 2110, 995, 2109, 994, 
        2108, 993, 1938, 639, 2104, 984, 2103, 983, 1937, 981, 2101, 739, 907,
         2054, 909, 2056, 910, 2057, 511, 1855}], 
       Line3DBox[{829, 831, 2003, 833, 524, 711, 2012, 2011, 850, 1861, 1860, 
        712, 1895, 1894, 727, 1893, 562, 564, 563, 1896, 886, 726, 1892, 561, 
        2039, 566, 888, 887, 730, 889, 567, 2151, 678, 1037, 2150, 1036, 776, 
        1039, 2153, 606, 1916, 607, 1035, 1960, 674, 773, 772, 1957, 673, 
        1958, 1959, 775, 1967, 1968, 1063, 2161, 2162, 684, 683, 1058, 1966, 
        1059, 1061, 525, 829}]}, 
      {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwl0b0rxHEcB/CPOHcZnDJIkY7VYGDiShjI07mQyXAuD8upS0eS+BP8C5JZ
Six2yuYhi8Ugm8ixel2Gd6/P5/37fn+/rssUNvOluogoSn9DxICsJSKyLLPA
LX7IRTJixf4rxVTEk+5U98BFOdRf2/fMvZxujNjXHcig1OuGmOAwWzjDNGfZ
w6q7Gf6wotvlNjt9r0P6vPNM7nVXnnXrHs03uiP3bnknr7onPkvWmRe+6ebM
7+bl2jn3czKpm5J1zyv2T2n3ri+21X6HvpkTbOIYUxxlkiP8drbLnOaOXJrL
+nM5sa/aj1ll3rcX9K3meZb0S8zJuGwk/v+LPyfSMNI=
        "]], Line3DBox[CompressedData["
1:eJwl0csrhGEYhvGHxozJIUqyUg5bCwvHxchiKMbCKLOy0TiHZIEk8l9YS9ZS
YiNrsmRyWCrZWKJs/CaLq+t+7ud736+vr212Pb9WERFF9CUiKlMRvbyBVnmn
KqIel/Km7hwn5gXzMX/xVDJiWl9Ak3lVn8KYeRSL8iD3Y14eKN/PaWziwpmc
O4r6H8xVR5T0p/oHLuBQf23+lffQJe/rcqiTM5zgIa7lcW7kSW7nb2c6eZcb
sF3+Pu/p9t4r84Hdmdyhy5of7XvkG/lWf49X3QveUDI/4RkZz73rPpGX75w5
ct+H3QwmdEt2y9iya7FbkZt5hNOc5Roe5mTq/1/8AbwBLuY=
        "]], Line3DBox[CompressedData["
1:eJwl0TsoxWEYx/FHOSgZkEW5LWIRjjBRUjblTC5JuV/qnMUiIYOSJBkMJqNZ
R0oKydksFspisUmKZKB8ZPj2uzzP///W+9aNZ1LpvIiYRFlhxEIi4gVvmCmI
mMqPGMOrPC2P8iPI2s3ohvgPvpk/5fftzMrVNCsf6jfppe4Cq/KG3MRX8C30
m6Z1lXwJX0XfaTHO+Dn/qqWLdvqLIp7lHvTiQH9rbwBdcrf5I83JN9gzf/Jd
p/5avkLOvF1uo/dmx3TdXpK24sROjfmS2fnfnejqaal+WbeCL75B14hyfke3
ix++XdeBbXlNTvJt2JLv5EF88ke6B34Yfc6YcGZKP5/4f4tfRGMzmQ==
        "]], Line3DBox[CompressedData["
1:eJwl0b8rxGEAx/FHOS6ZxMTgBikGUkLZlNVhIonLcel77pZbpAxEkqw2GfwF
cpKJ5QaTX5vFgMVNGBjw+mZ493l/Ps/3nme4VKYwsVITQsghSoSwUBfCSX0I
k7UhZHgmGcKdfQoftmNnN/yT76Jfz/vuSu7pg/LH+S+G+L6tmXfxL/mNbr5m
b+KdvAPL7li1tXuvbF+P39FvMaqfIeXsXq/E7+kD+jV/sj3IYb1if+TPtrT+
yqt8RL7JA/e+8DFnJT3Hz20XaPTbyNbGizKPVl6QG+jl23ITPXxL9snIHZdy
J97dcYisPm4/tR3p73qZT6OFZ53N8FnMo+ibJOb4IpZQ0htQTfz/N399Pzix

        "]], Line3DBox[CompressedData["
1:eJwl0M8rA3AYx/Fnmc1lBwdSTk4u2h+gdnMgJamhKcofYKLdJZmLA2nJEJIb
aycnF9TKn6BW1DLlsHLl4LUc3n1+PN/nOXxHVotza4mIWMBWb8R4OuIgGVFK
Rbzwu7odVHQ1eodUX8SJ+aMuyz/o9ry9143JObmOZ/N5XdFsHRsooaHvYMXs
TD7HF5+3u4hvs0/7Nf2vflM31b1Dp+mb2TsSaKEHP3YyZhf0UL6kR/SKlvWv
bg3LVbnJV/gJekyvdZN8v3f7aPOj+g86K7foDL3xLs8P8bf8cvcmv0QLGOBP
7Q2iIW/Tp/T/v/4BUJwxVQ==
        "]], Line3DBox[CompressedData["
1:eJwl0D1LgmEYhuG7eDMhaGgwBKFaoiXaC1yiIRECCSUQCn9A0QfuEQ1BUxJi
RYtES4RjU4sONvUPCgKHtiBoSuiAhpPr67mXZ662V9odiYgKVsYjjscievSE
9uk0LdFGKiKDKp+j2/QxicjyZf6ef6cb8oDOu1vAFYrylH6d3nnX0q3xTfpG
b3Q5/hKrclue5RuYwTkm3f/qE36AUXyghgc3P/YCjtIRQ9rRfdq+3WzpytjE
ju1VX+W/bH3UvT3EPir2Nibsy97lscg/6c7sz/KS3HV3rbtFWu7om7pT+uLd
gb6Oi+T/X/8AtkYtlg==
        "]], Line3DBox[CompressedData["
1:eJwl0D1LgnEUhvETaBoVtQVCg0tze0LQkHsFRuDQy9qTkuBXCKMWG4QiCRoi
gqCtD+AghHMgQdEWLU1Nkb8Hh4vrPvc5zx+xuHe0kUxExCZiMqKUi0i4x+1M
xGXWTt7ChX4BVfnB7hEFc8V8J79zy7zO83yvK8un8gcXvXUiD+Vpfk13ukVc
uz3nNd0Zz9n/6bLyAT6xj1o+4o1/7RP5302dv9LfiR15wBXedXPjvS6+5R+3
fTTNDWzrbjHrdgYrvntCz03L/tluWb/Eh+Yr7qZvYkrfcbeqr5mP0cRLbvw/
jgApSixZ
        "]], 
       Line3DBox[{1537, 1853, 1647, 1990, 1172, 1195, 2031, 1437, 1880, 1881, 
        1325, 2030, 1316, 1193, 1866, 1867, 1676, 2019, 1317, 2018, 1314, 
        1673, 2012, 1548, 1181, 1425, 2009, 1424, 1423, 1310, 1183, 1278, 
        1503, 1502, 1965, 1784, 1635, 1280, 2162, 1515, 1364, 2139, 1605, 
        2141, 1488, 1954, 1952, 1362, 1343, 2058, 1577, 2063, 2062, 1701, 
        2064, 1340, 1222, 1931, 1722, 2097, 1575, 1693, 2055, 1696, 1698, 
        1539, 1649, 1652, 1995, 1656, 1537}], 
       Line3DBox[{1538, 1854, 1173, 1888, 1685, 2032, 2033, 2034, 1322, 2024, 
        2025, 1678, 1871, 1872, 1315, 1543, 1417, 2003, 1667, 1666, 1544, 
        1787, 1786, 1966, 1785, 1286, 1365, 2145, 2144, 1773, 1956, 1955, 
        1336, 2049, 2048, 2047, 1689, 2050, 1217, 1902, 1576, 1704, 2071, 
        1705, 1707, 1541, 1660, 1662, 2001, 1664, 1538}], 
       Line3DBox[{1177, 1856, 1657, 1997, 1658, 1998, 1659, 2000, 1304, 1418, 
        2005, 1669, 1857, 1668, 2004, 1546, 2167, 1793, 2166, 1792, 1969, 
        1790, 1232, 1918, 1709, 2073, 1710, 2074, 1711, 2075, 1177}], 
       Line3DBox[{1416, 1665, 1178, 1511, 1510, 1381, 1970, 1791, 2165, 1606, 
        2143, 2142, 1337, 2053, 2052, 2051, 1573, 1917, 1460, 1348, 2072, 
        1706, 1708, 1542, 1661, 1663, 2002, 1305, 1415, 1999, 1540, 1889, 
        1890, 1891, 1321, 1869, 1870, 1545, 2007, 1670, 2006, 1306, 1416}], 
       Line3DBox[{1680, 1873, 1679, 2026, 1556, 2157, 1781, 2156, 1780, 1962, 
        1500, 1355, 1936, 1731, 2098, 1732, 2099, 1733, 2100, 1247, 1943, 
        1761, 2119, 1762, 2120, 1764, 2122, 1324, 1681, 2027, 1680}], 
       Line3DBox[CompressedData["
1:eJwl0C9IQ2EUhvEjqNdsFzawmUR0oMhcWlMUVoQhmpzCVnVxKCaTKAbzUFgR
LTKcRhluIlg0mBfFIiztNwwP759zznfhpncqG+WRiFjH1HjE7WhEP4lojEXs
05b8hIxcMN/TlTAvn9NvXW4iYlVuYw0X+pw+izP+RdfzxhW/rPvAopt32sUS
nvGIUzvN4RwnfN7tHV/jF+gmjvkv7zXNMvK0t+7pkX5Fd0AP0bbTQRcz5lVd
nU7af9W9ocT/6LbcbeOX7+tv7BblT+zaSekvcS0/DL+NOX4Wdfwl//9vACDq
Lw0=
        "]], Line3DBox[CompressedData["
1:eJwl0D1LgnEUhvETZPYBqt00sBcMgiJXK7GhJacQIqIpoj5AzU19g6A1NIKg
RcSwwa0laImiCJy0qa3ApB80XNz3uc75P8OT2j3aPByKiDIuEhF7yYib4Yg6
Jkcivs1XfEqvySoW0LD/watesnuRX3J/NGJH38a8+cT7W72AY32Oy+ESE25X
+HE5hi3uwTen9GV9Rpbsp2UWDX0di3bP7ma5pvnUd9/MLf1Mb9q38M61uUc9
7/ZJdrhzNz29zG3Yd7kePrhVbg2f5qKscAW55O6O63v7i3t9IK/5jJs0Dsy5
xP9//ANcJi71
        "]], 
       Line3DBox[{1923, 1717, 2086, 1345, 2065, 1578, 2067, 1581, 2155, 1779, 
        1963, 1371, 1774, 2150, 1372, 1775, 2151, 1567, 1447, 1620, 1687, 
        1323, 2028, 1682, 2029, 1555, 2043, 1332, 2041, 1212, 2112, 1481, 
        1940, 1628, 1759, 2115, 1600, 2121, 1763, 1356, 2107, 1746, 1743, 
        1596, 1729, 1726, 1934, 1354, 1730, 1935, 1593, 2087, 1718, 1241, 
        1923}]}}},
    VertexNormals->CompressedData["
1:eJx0unk41V/UNi5UUjRooKJQVFQ0J6ykQRpkKCJTKJQhQ6VCVMhQIclUpgZl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     "]], {}},
  Axes->True,
  AxesLabel->{
    FormBox["\"x\"", TraditionalForm], 
    FormBox["\"y\"", TraditionalForm], 
    FormBox["\"z\"", TraditionalForm]},
  AxesOrigin->{0, 0, 0},
  BoxRatios->{1, 1, 1},
  Boxed->False,
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}},
  PlotRange->{{-2, 2}, {-2, 2}, {-2, 2}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.973340579027241*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"f6130206-72a9-4620-9833-4844a2a79b08"]
}, Open  ]]
},
WindowSize->{569.25, 609.75},
WindowMargins->{{-921, Automatic}, {28.5, Automatic}},
FrontEndVersion->"13.0 para Microsoft Windows (64-bit) (February 4, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e9ba8cbb-6559-45ad-b480-e130b093508c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 183, 4, 28, "Input",ExpressionUUID->"69f4cbaa-ac24-4f2b-90e7-b21de5767049"],
Cell[CellGroupData[{
Cell[766, 28, 1289, 34, 162, "Input",ExpressionUUID->"af2e5bbe-c95d-4e09-b860-4a3422938bf3"],
Cell[2058, 64, 139827, 2314, 407, "Output",ExpressionUUID->"f6130206-72a9-4620-9833-4844a2a79b08"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

